% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COR.R
\name{COR}
\alias{COR}
\title{Caculate the optimal subset lengths on the COR}
\usage{
COR(K = K, nk = nk, alpha = alpha, X = X, y = y)
}
\arguments{
\item{K}{is the number of subsets}

\item{nk}{is the length of subsets}

\item{alpha}{is the significance level}

\item{X}{is the observation matrix}

\item{y}{is the response vector}
}
\value{
seqL, seqN,lWMN
}
\description{
Caculate the optimal subset lengths on the COR
}
\examples{
 p=6;n=1000;K=2;nk=200;alpha=0.05;sigma=1
 e=rnorm(n,0,sigma); beta=c(sort(c(runif(p,0,1)))); 
 data=c(rnorm(n*p,5,10));X=matrix(data, ncol=p);
 y=X\%*\%beta+e;
 COR(K=K,nk=nk,alpha=alpha,X=X,y=y)
}
