% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimation}
\alias{estimation}
\title{Conducting Gaussian Process Regression}
\usage{
estimation(
  Y,
  X,
  K_list = NULL,
  mode = "loocv",
  strategy = "stack",
  beta_exp = 1,
  lambda = exp(seq(-10, 5)),
  ...
)
}
\arguments{
\item{Y}{(matrix, n*1) The vector of response variable.}

\item{X}{(matrix, n*d_fix) The fixed effect matrix.}

\item{K_list}{(list of matrices) A nested list of kernel term matrices. 
The first level corresponds to each base kernel function in kern_func_list, 
the second level corresponds to each kernel term specified in the formula.}

\item{mode}{(character) A character string indicating which tuning parameter
criteria is to be used.}

\item{strategy}{(character) A character string indicating which ensemble
strategy is to be used.}

\item{beta_exp}{(numeric/character) A numeric value specifying the parameter
when strategy = "exp" \code{\link{ensemble_exp}}.}

\item{lambda}{(numeric) A numeric string specifying the range of tuning 
parameter to be chosen. The lower limit of lambda must be above 0.}

\item{...}{Additional parameters to pass to estimate_ridge.}
}
\value{
\item{lambda}{(numeric) The selected tuning parameter based on the
estimated ensemble kernel matrix.}

\item{beta}{(matrix, d_fixed*1) Fixed effect estimates.}

\item{alpha}{(matrix, n*1) Kernel effect estimates.}

\item{K}{(matrix, n*n) Estimated ensemble kernel matrix.}

\item{u_hat}{(vector of length K) A vector of weights of the kernels in the
library.}

\item{kern_term_effect}{(matrix, n*n) Estimated ensemble kernel effect matrix.}

\item{base_est}{(list) The detailed estimation results of K kernels.}
}
\description{
Conduct Gaussian process regression based on the estimated ensemble kernel
matrix.
}
\details{
After obtaining the ensemble kernel matrix, we can calculate the output of
Gaussian process regression.
}
\seealso{
strategy: \code{\link{ensemble}}
}
\author{
Wenying Deng
}
