% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_event_prob.R
\name{get_event_prob}
\alias{get_event_prob}
\title{Draw event probabilities}
\usage{
get_event_prob(model, P = NULL, A = NULL, parameters = NULL, type_prob = NULL)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{P}{A \code{data.frame}. Parameter matrix. Not required but may be provided to avoid repeated computation for simulations.}

\item{A}{A \code{data.frame}. Ambiguity matrix. Not required but may be provided to avoid repeated computation for simulations.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to specify (optional). By default, parameters is drawn from \code{model$parameters_df}.}

\item{type_prob}{A numeric vector. Type probabilities. (Not required).}
}
\value{
An {array} of event probabilities
}
\description{
Draw event probabilities
}
\examples{
\donttest{
model <- make_model('X -> Y')
get_event_prob(model = model)
get_event_prob(model = model, parameters = rep(1, 6))
get_event_prob(model = model, parameters = 1:6)
}
}
