% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdh_r.R
\name{gdhr_model}
\alias{gdhr_model}
\title{GDH Model - Richardson - for heat accumulation}
\usage{
gdhr_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of GDH for each temperature (TRUE is default).}
}
\value{
The function returns values the GDH for each temperature of vector.
}
\description{
Quantifies the Growing Degree Hours at between the base and optimum temperatures.
}
\details{
The GDH model is based on the subtraction of the base temperature of each hourly temperature between 4.5°C and 25°C. The temperature of the base is 4.5°C. Therefore, accumulation under temperatures below 4.5°C and above 25°C is zero.
}
\examples{

x <- rnorm(500,8,3)
gdhr_model(x)
gdhr_model(x, FALSE)

}
\references{
RICHARDSON, E.A. et al. 1975. Pheno-climatographyof spring 249 peach bud development. HortScience.
}
