#' CircSpaceTime: implementation of Bayesian models,
#' for spatial and spatio-temporal interpolation of circular data.
#'
#' The CircSpaceTime package provides two categories of important functions:
#' Sampling Functions and Posterior (Kriging) Estimation Functions.
#'
#' @section CircSpaceTime main functions:
#'
#' \code{\link{WrapSp}} and \code{\link{ProjSp}}, for sampling
#' from a spatial Normal Wrapped and Projected, respectively.
#' \code{\link{WrapKrigSp}} and \code{\link{ProjKrigSp}}, for posterior
#' estimation on spatial Normal Wrapped and Projected, respectively.
#'
#' \code{\link{WrapSpTi}} and \code{\link{ProjSpTi}}, for sampling
#' from a spatio-temporal Normal Wrapped and Projected, respectively.
#' \code{\link{WrapKrigSpTi}} and \code{\link{ProjKrigSpTi}}, for posterior
#' estimation on spatio-temporal Normal Wrapped and Projected, respectively.
#'
#'
#' @docType package
#' @name CircSpaceTime
NULL
