% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{koi}
\alias{koi}
\title{Kerner Oceanity Index}
\usage{
koi(data, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{data}{daily mean temperature, Celsius}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{further arguments passed to or from other methods}
}
\value{
index value
}
\description{
KOI analysed the oceanity assuming that marine climates have colder spring months in comparison with the autum months.
}
\section{Formula}{
 \deqn{KOI = \frac {100(TGo-TGa)}{Thm-Tcm}} TGo = Average temperature of October TGa = Average temperature of April Thm = Average temperature of the hottest month (Celsius); Tcm = Average temperature of the coldest month (Celsius)
}

\examples{
data(data_all)
koi(data = data_all$tg)
}
\references{
Zambakas J. 1992.General Climatology. Department of Geology,National & Kapodistrian University of Athens, Athens. Gavilan RG. 2005. The use of climatic parameters and indices in vege-tation distribution. A case study in the Spanish System Central.Int. J.Biometeorol.50: 111–120.
}
