% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.torus.R, R/methods.R
\name{hyperparam.torus}
\alias{hyperparam.torus}
\alias{plot.hyperparam.torus}
\title{Selecting optimal hyperparameters for the conformal prediction set}
\usage{
hyperparam.torus(
  icp.torus.objects,
  option = NULL,
  alphavec = NULL,
  alpha.lim = NULL,
  eval.point = NULL
)

\method{plot}{hyperparam.torus}(x, color = "auto", ...)
}
\arguments{
\item{icp.torus.objects}{list whose elements are icp.torus objects, generated by
\code{icp.torus}}

\item{option}{A string. One of "elbow", "risk", "AIC", or "BIC", which determines the
criterion for the model selection. "risk" is based on the negative log-likelihood, "AIC"
for the Akaike Information Criterion, and "BIC" for the Bayesian Information Criterion.
"elbow" is based on minimizing the criterion used in Jung et. al.(2021). Default is
\code{option = "elbow"} for 2-dimensional cases and \code{option = "risk"} for d(>2)-dimensional cases.}

\item{alphavec}{either a scalar or a vector, or even \code{NULL} for the levels.
Default value is \code{NULL}. If \code{NULL}, then \code{alphavec} is
automatically generated as a sequence from 0 to \code{alpha.lim}.}

\item{alpha.lim}{a positive number lower than 1. Default value is \code{NULL}.
If \code{NULL}, then \code{alpha.vec} is is 0.5 for \code{option = "elbow"}, and
0.15 for options c("risk", "AIC", or "BIC").}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^2}.
Default input is \code{grid.torus}.}

\item{x}{\code{hyperparam.torus} object}

\item{color}{A string for plotting \code{hyperparam.torus} object, whose criterion option is \code{option = "elbow"}.
One of "auto", "sequential", or "qualitative". If \code{color = "auto"},
color assignment will be done automatically based on the number of J or concentration.
If \code{color = "sequential"}, color assignment will be done by regarding each J or concentration as quantitative variable.
If \code{color = "qualitative"}, color assignment will be done by regarding each J or concentration as qualitative variable.
Default is \code{color = "auto"}.}

\item{...}{additional parameter for ggplot2::ggplot()}
}
\value{
returns a list object which contains \code{data.frame} objects for
  the evaluated criterion corresponding to each hyperparameter,
  selected hyperparameters based on the designated criterion, and
  an \code{icp.torus} object based the selected hyperparameters.
}
\description{
\code{hyperparam.torus} selects optimal hyperparameters for constructing the conformal prediction
  set, based on the type of postulated model and the criterion.
}
\examples{
\donttest{
data <- toydata2[, 1:2]
n <- nrow(data)
split.id <- rep(2, n)
split.id[sample(n, floor(n/2))] <- 1
Jvec <- 3:35
icp.torus.objects <- icp.torus(data, split.id = split.id, model = "kmeans",
                                      kmeansfitmethod = "ge", init = "h",
                                      J = Jvec, verbose = TRUE)
hyperparam.torus(icp.torus.objects, option = "risk")
}
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.

  Akaike, H. (1974). A new look at the statistical model identification. \emph{IEEE transactions on automatic control}, 19(6), 716-723.

  Schwarz, G. (1978). Estimating the dimension of a model. \emph{The annals of statistics}, 461-464.
}
