% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshapeTranspose.R
\name{reshapeTranspose}
\alias{reshapeTranspose}
\title{Transpose Data}
\usage{
reshapeTranspose(
  dataset = cs.in.dataset(),
  groups = cs.in.groupvars(),
  scriptvars = cs.in.scriptvars(),
  return.results = FALSE,
  ...
)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{groups}{[\code{character}]\cr
Character vector of group variables.}

\item{scriptvars}{[\code{list}]\cr
Named list of script variables set via the Cornerstone "Script Variables" menu.
For details see below.}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}

\item{...}{[ANY]\cr
Additional arguments to be passed to 
\code{\link[data.table]{transpose}}
. Please consider possible script variables (\code{scriptvars}) to prevent duplicates.}
}
\value{
Logical [\code{TRUE}] invisibly and outputs to Cornerstone or, 
  if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} object:
  \item{reshapeTranspose}{Dataset with transposed data.}
}
\description{
Transpose data via \code{\link[data.table]{transpose}}.
  All predictors, responses, groups, and auxiliaries are transpose.
}
\details{
One script variables is summarized in \code{scriptvars} list:\cr
  \describe{
    \item{split}{[\code{character(1)}]\cr
      Split character to split response names into multiple columns. Default is \dQuote{_}.}
  }
}
\examples{
# Data to transform:
library(data.table)
dtTest = data.table(i_1 = c(1:4, NA, 5), i_2 = c(51, 61, NA , 71, 81, 91))
# Reshape to long format:
reshapeTranspose(dtTest, groups = character(0), list(convert.numeric = TRUE), return.results = TRUE)
}
