% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.trainFunctions.TwoClass.R
\name{TwoClass}
\alias{TwoClass}
\title{Control parameters for train stage (Bi-class problem).}
\description{
Implementation to control the computational nuances of train
function for bi-class problems.
}
\seealso{
\code{\link{TrainFunction}}
}
\section{Super class}{
\code{\link[D2MCS:TrainFunction]{D2MCS::TrainFunction}} -> \code{TwoClass}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TwoClass$new()}}
\item \href{#method-create}{\code{TwoClass$create()}}
\item \href{#method-getTrFunction}{\code{TwoClass$getTrFunction()}}
\item \href{#method-setClassProbs}{\code{TwoClass$setClassProbs()}}
\item \href{#method-getMeasures}{\code{TwoClass$getMeasures()}}
\item \href{#method-getType}{\code{TwoClass$getType()}}
\item \href{#method-setSummaryFunction}{\code{TwoClass$setSummaryFunction()}}
\item \href{#method-clone}{\code{TwoClass$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getAllowParallel">}\href{../../D2MCS/html/TrainFunction.html#method-getAllowParallel}{\code{D2MCS::TrainFunction$getAllowParallel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getClassProbs">}\href{../../D2MCS/html/TrainFunction.html#method-getClassProbs}{\code{D2MCS::TrainFunction$getClassProbs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getNumberFolds">}\href{../../D2MCS/html/TrainFunction.html#method-getNumberFolds}{\code{D2MCS::TrainFunction$getNumberFolds()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getResamplingMethod">}\href{../../D2MCS/html/TrainFunction.html#method-getResamplingMethod}{\code{D2MCS::TrainFunction$getResamplingMethod()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getSavePredictions">}\href{../../D2MCS/html/TrainFunction.html#method-getSavePredictions}{\code{D2MCS::TrainFunction$getSavePredictions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getSeed">}\href{../../D2MCS/html/TrainFunction.html#method-getSeed}{\code{D2MCS::TrainFunction$getSeed()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="TrainFunction" data-id="getVerboseIter">}\href{../../D2MCS/html/TrainFunction.html#method-getVerboseIter}{\code{D2MCS::TrainFunction$getVerboseIter()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$new(
  method,
  number,
  savePredictions,
  classProbs,
  allowParallel,
  verboseIter,
  seed = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The resampling method: "boot", "boot632", "optimism_boot",
"boot_all", "cv", "repeatedcv", "LOOCV", "LGOCV" (for repeated
training/test splits), "none" (only fits one model to the entire training
set), "oob" (only for random forest, bagged trees, bagged earth, bagged
flexible discriminant analysis, or conditional tree forest models),
timeslice, "adaptive_cv", "adaptive_boot" or "adaptive_LGOCV"}

\item{\code{number}}{Either the number of folds or number of resampling
iterations}

\item{\code{savePredictions}}{An indicator of how much of the hold-out
predictions for each resample should be saved. Values can be either
"all", "final", or "none". A logical value can also be used that convert
to "all" (for true) or "none" (for false). "final" saves the predictions
for the optimal tuning parameters.}

\item{\code{classProbs}}{A \link{logical} value. Should class probabilities be
computed for classification models (along with predicted values) in each
resample?}

\item{\code{allowParallel}}{A \link{logical} value. If a parallel backend is
loaded and available, should the function use it?}

\item{\code{verboseIter}}{A \link{logical} for printing a training log.}

\item{\code{seed}}{An optional \link{integer} that will be used to set the seed
during model training stage.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create"></a>}}
\if{latex}{\out{\hypertarget{method-create}{}}}
\subsection{Method \code{create()}}{
Creates a \code{\link[caret]{trainControl}} requires for the
training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$create(summaryFunction, search.method = "grid", class.probs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{summaryFunction}}{An object inherited from
\code{\link{SummaryFunction}} class.}

\item{\code{search.method}}{Either "grid" or "random", describing how the tuning
parameter grid is determined.}

\item{\code{class.probs}}{A \link{logical} indicating if class probabilities
should be computed for classification models (along with predicted values)
in each resample}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTrFunction"></a>}}
\if{latex}{\out{\hypertarget{method-getTrFunction}{}}}
\subsection{Method \code{getTrFunction()}}{
Function used to return the
\code{\link[caret]{trainControl}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$getTrFunction()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link[caret]{trainControl}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setClassProbs"></a>}}
\if{latex}{\out{\hypertarget{method-setClassProbs}{}}}
\subsection{Method \code{setClassProbs()}}{
The function allows changing the class computation
capabilities.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$setClassProbs(class.probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class.probs}}{A \link{logical} value. \link{TRUE} implies
classification probabilities should be computed for classification models
and \link{FALSE} otherwise.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMeasures"></a>}}
\if{latex}{\out{\hypertarget{method-getMeasures}{}}}
\subsection{Method \code{getMeasures()}}{
Returns the measures used to optimize model hyperparameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$getMeasures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getType"></a>}}
\if{latex}{\out{\hypertarget{method-getType}{}}}
\subsection{Method \code{getType()}}{
Obtains the type of classification problem ("Bi-class" or
"Multi-class").
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$getType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector with "Bi-class" value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSummaryFunction"></a>}}
\if{latex}{\out{\hypertarget{method-setSummaryFunction}{}}}
\subsection{Method \code{setSummaryFunction()}}{
Function used to change the \code{\link{SummaryFunction}}
used in the training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$setSummaryFunction(summaryFunction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{summaryFunction}}{An object inherited from
\code{\link{SummaryFunction}} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TwoClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
