% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_plot_island.R
\name{DAISIE_plot_island}
\alias{DAISIE_plot_island}
\title{Plot colonisation and branching time of species found on an island dataset.}
\usage{
DAISIE_plot_island(island, island_age = NA)
}
\arguments{
\item{island}{Island data object. Can be in DAISIE list format (see
Galapagos_datalist and DAISIE_data_prep for examples) or in table format
(see Galapagos_datatable for an example).}

\item{island_age}{Age of island in appropriate units. In
\code{\link{DAISIE_plot_age_diversity}()} and
\code{\link{DAISIE_plot_island}()} if island input is in table format,
the age of the island must be specified. If island input is in DAISIE list
format, this option will override the island age specified in the island
list.}
}
\value{
R plot.
}
\description{
Produces an image with the times of colonisation, branching times, clade
name and clade status for all clades found in a given dataset.
}
\details{
R plot showing for each clade in the island object: time of colonisation,
branching times, species status (endemic or non-endemic), total number of
species in clade (n), number of species not sampled (m).
}
\examples{


### Plot Galapagos islands dataset from data table (specify island age)

utils::data(Galapagos_datatable)
DAISIE_plot_island(Galapagos_datatable, island_age=4)

### Plot Galapagos islands dataset from datalist (no need to specify
## island age)
utils::data(Galapagos_datalist)
DAISIE_plot_island(Galapagos_datalist)

}
\references{
Valente, L.M., A.B. Phillimore and R.S. Etienne (2015).
Equilibrium and non-equilibrium dynamics simultaneously operate in the
Galapagos islands. Ecology Letters 18: 844-852.
}
\seealso{
\code{\link{DAISIE_sim_constant_rate}},
\code{\link{DAISIE_sim_time_dependent}},
\code{\link{DAISIE_sim_constant_rate_shift}},
\code{\link{DAISIE_plot_age_diversity}}
}
\author{
Luis Valente
}
\keyword{models}
