% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reduceOpen}
\alias{reduceOpen}
\title{chop down or group down the open age}
\usage{
reduceOpen(X, maxA = 75, group = TRUE)
}
\arguments{
\item{X}{data formatted per the requirements of \code{bh1()}, \code{bh2()}}

\item{maxA}{integer ignore ages above this age.}

\item{group}{logical. If \code{TRUE} we sum down to \code{min(maxA,95)}. If \code{FALSE}, we just chop off data above that age.}
}
\value{
X, with the open age having been reduced either with or without aggregation.
}
\description{
These methods are not intended to be applied to ages greater than, say 90 or 95. Usually, we'd top out in the range 75 to 85. In any case, the Coale-Demeny life table implementation that we have only goes up to age 95, so there is a practical limitation to deriving a remaining life expectancy for the open age group. If a user tries to apply the Bennett-Horiuchi methods to data with higher open ages, stuff breaks for the time being. So this function chops the data off at \code{min(maxA,95)}, after having (optionally) grouped data down. This function needs to work with a single partition of data (intercensal period, sex, region, etc).
}
