% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.functions.R, R/PT.Design.R,
%   R/PT.Nested.Design.R, R/PT.Systematic.Design.R, R/LT.Design.R,
%   R/LT.EqSpace.ZZ.Design.R, R/LT.Systematic.Design.R, R/Simulation.R
\name{generate.transects}
\alias{generate.transects}
\alias{generate.transects,PT.Design-method}
\alias{generate.transects,PT.Nested.Design-method}
\alias{generate.transects,PT.Systematic.Design-method}
\alias{generate.transects,LT.Design-method}
\alias{generate.transects,LT.EqSpace.ZZ.Design-method}
\alias{generate.transects,LT.Systematic.Design-method}
\alias{generate.transects,Simulation-method}
\title{S4 generic method to generate an instance of a design}
\usage{
generate.transects(object, region = NULL, ...)

\S4method{generate.transects}{PT.Design}(object, region = NULL, index = NULL)

\S4method{generate.transects}{PT.Nested.Design}(object, region = NULL, index = NULL, silent = FALSE)

\S4method{generate.transects}{PT.Systematic.Design}(object, region = NULL, index = NULL, silent = FALSE)

\S4method{generate.transects}{LT.Design}(object, region = NULL, index = NULL)

\S4method{generate.transects}{LT.EqSpace.ZZ.Design}(
  object,
  region = NULL,
  index = NULL,
  silent = FALSE,
  complement = FALSE
)

\S4method{generate.transects}{LT.Systematic.Design}(object, region = NULL, index = NULL, silent = FALSE)

\S4method{generate.transects}{Simulation}(object, region = NULL)
}
\arguments{
\item{object}{an object of class Simulation or a class which inherits from 
Survey.Design}

\item{region}{optional only required if object is of class Survey.Design.}

\item{...}{optional argument index if an object of class Survey.Design is 
supplied allowing the user to access / plot different sets of transects
listed in the filenames slot.}

\item{index}{specifies which set of transect should be loaded}

\item{silent}{if TRUE does not report warnings about a single value for nested spacing with a multi strata region}

\item{complement}{logical indicating whether two sets of complimentary transects should be generated}
}
\value{
an object of class Line.Transect
}
\description{
Uses the Survey.Design details to generate transects. Currently this 
involves loading a survey shapefile from the path specified in the 
Survey.Design object and can only work with line transect designs.
}
