% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellBasins.R
\name{cellBasins}
\alias{cellBasins}
\title{Identification of the Cells within a basin}
\usage{
cellBasins(gruLoc, basins)
}
\arguments{
\item{gruLoc}{raster file that was used to build GRUs. In this function will be used to number each cell
from West to East and from North to South.}

\item{basins}{a shapefile that is comprised each one of the basins where the modeller wants to know the runoff.
It must be in the same projection of the gruLoc raster.}
}
\value{
a list that comprise two dataframes. The first one, the list of cells in each of the basins contained in the shapefile (\code{cellBasins}), 
and second a table that associates the coordinates of each cell with the assigned number (\code{cellTable}).
}
\description{
This function identifies the cells that are within a basin. The runoff produced by those cells
will be used, either to calculate the water availability or to compare the simulated variable with the observed runoff
in certain streamflow gauges.
}
\examples{
data("GRU","basins")
cellBasins <- cellBasins(GRU, basins)

}
\author{
Pedro Felipe Arboleda Obando <pfarboledao@unal.edu.co> \cr
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co> \cr
Carolina Vega Viviescas <cvegav@unal.edu.co> \cr
David Zamora <dazamoraa@unal.edu.co> \cr
 
Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - sede Bogota
}
