% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_svg.R
\name{export_svg}
\alias{export_svg}
\title{Export grViz graph as SVG with \code{V8}}
\usage{
export_svg(gv)
}
\arguments{
\item{gv}{htmlwidget to render as SVG.}
}
\value{
\code{string} of SVG XML text.
}
\description{
Use viz.js with \code{V8} to get the diagram rendered as SVG
in R instead of the browser.
}
\examples{
\dontrun{
 library(DiagrammeR)
 svg <- export_svg(grViz('digraph{a->b; c->a; c->b; c->d;}'))

 # this can then be used with htmltools and can save significantly
 # on size of output using svg rather than unrendered grViz
 library(htmltools)
 html_print(HTML(svg))
}
}

