% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{vcov.DE}
\alias{vcov.DE}
\title{vcov method for class 'DE'}
\usage{
\method{vcov}{DE}(object, ...)
}
\arguments{
\item{object}{An object of class \code{DE}.}

\item{...}{Unused}
}
\value{
A \eqn{N \times (k_1 + k_2 + 3)}{N x (k[1] + k[2] + 3)} if matrix of the gradient is returned.
}
\description{
vcov method for class 'DE'
}
\examples{
set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)
df = data.frame(Y = Y, X1 = Xgen[,1], X2 = Xgen[,2])

results = DE(formula = Y ~ X1 | X2, data = df)

vcov(results)

}
