% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparelme.R
\name{lm_slopes_compare}
\alias{lm_slopes_compare}
\title{Compare the slopes of two lme models}
\usage{
lm_slopes_compare(VAR1, VAR2)
}
\arguments{
\item{VAR1}{An lme4 object}

\item{VAR2}{An lme4 object that has the same variables, in the same order as VAR1.}
}
\value{
Z-tests comapring slopes.
}
\description{
This allows you to compare two lme4 models that have the same fixed predictors but differ in other ways (e.g., from different datasets, different random effects). It will produce a Z score a p-value for each effect.
}
\examples{
\dontrun{model1<-lmer(DV~IV1+IV2+IV3+(1|subject),data=DATA_1)}
\dontrun{model2<-lmer(DV~IV1+IV2+IV3+(1|subject),data=DATA_2)}
 \dontrun{lm_slopes_compare(model1,model2)}
}
\keyword{Compare}
\keyword{slopes}
