% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countBamInGranges.R
\name{countBamInGRanges.exomeDepth}
\alias{countBamInGRanges.exomeDepth}
\title{Compute read count data from BAM files.}
\usage{
countBamInGRanges.exomeDepth(
  bam.file,
  index = bam.file,
  granges,
  min.mapq = 1,
  read.width = 1
)
}
\arguments{
\item{bam.file}{BAM file to be parsed}

\item{index}{Index of the BAM file, without the '.bai' suffix.}

\item{granges}{Genomic ranges object defining the bins}

\item{min.mapq}{Minimum read mapping quality (Phred scaled).}

\item{read.width}{For single end reads, an estimate of the frament size. For
paired reads, the fragment size can be directly computed from the paired
alignment and this value is ignored.}
}
\value{
A GRanges object with count data.
}
\description{
Parses a BAM file and count reads that are located within a target region
defined by a GenomicRanges object.
}
\details{
Largely derived from its equivalent function in the exomeCopy package.
}
