% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_definition.R
\name{initialize,ExomeDepth-method}
\alias{initialize,ExomeDepth-method}
\title{ExomeDepth initialization tool}
\usage{
\S4method{initialize}{ExomeDepth}(
  .Object,
  data = NULL,
  test,
  reference,
  formula = "cbind(test, reference) ~ 1",
  phi.bins = 1,
  prop.tumor = 1,
  subset.for.speed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{.Object}{ExomeDepth object}

\item{data}{Data frame containing potential covariates.}

\item{test}{Numeric, vector of counts for the test sample.}

\item{reference}{Numeric, vector of counts for the reference sample.}

\item{formula}{Linear model to be used when fitting the data.}

\item{phi.bins}{Numeric, defaults to 1. Number of discrete bins for the over-dispersion parameter phi, depending on read depth.
Do not modify this parameter for the standard use of ExomeDepth.}

\item{prop.tumor}{Numeric, defaults to 1. For the somatic variant calling, this assesses the proportion of the test sample data originating from the tumour.
Do not modify this parameter for the standard use of ExomeDepth.}

\item{subset.for.speed}{Numeric, defaults to NULL. If non-null, this sets the number of data points to be used for an accelerated fit of the data.}

\item{verbose}{Logical, controls the output level.}
}
\description{
Builds an exomeDepth object from test and reference vectors
}
