% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat3.ad.crd.R
\name{fat3.ad.crd}
\alias{fat3.ad.crd}
\title{Triple factorial scheme plus an additional treatment
in CRD}
\usage{
fat3.ad.crd(
  factor1,
  factor2,
  factor3,
  repet,
  resp,
  respAd,
  quali = c(TRUE, TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2", "F3"),
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{factor1}{Numeric or complex vector containing the
factor 1 levels.}

\item{factor2}{Numeric or complex vector containing the
factor 2 levels.}

\item{factor3}{Numeric or complex vector containing the
factor 3 levels.}

\item{repet}{Numeric or complex vector containing the
replications.}

\item{resp}{Numeric or complex vector containing the
response variable.}

\item{respAd}{Numeric or complex vector containing the
additional treatment.}

\item{quali}{Logic. If TRUE (default), the treatments
are assumed qualitative, if FALSE, quantitatives.}

\item{mcomp}{Allows choosing the multiple comparison
test; the \emph{default} is the test of Tukey, however,
the options are: the LSD test ('lsd'), the LSD test with
Bonferroni protection ('lsdb'), the test of Duncan
('duncan'), the test of Student-Newman-Keuls ('snk'),
the test of Scott-Knott ('sk'), the Calinski and
Corsten test ('ccF') and bootstrap multiple
comparison's test ('ccboot').}

\item{fac.names}{Allows labeling the factors 1, 2 and 3.}

\item{sigT}{The signficance to be used for the multiple
comparison test; the default is 5\%.}

\item{sigF}{The signficance to be used for the F test of
ANOVA; the default is 5\%.}

\item{unfold}{Says what must be done after the ANOVA.
If NULL (\emph{default}), recommended tests are performed;
if '0', just ANOVA is performed; if '1', the simple effects
are tested; if '2.1', '2.2' or '2.3', the double interactions
are unfolded; if '3', the triple interaction is unfolded.}
}
\value{
The output contains the ANOVA of the referred
CRD, the Shapiro-Wilk normality test for the residuals
of the model, the fitted regression models (when the
treatments are quantitative) and/or the multiple
comparison tests (when the treatments are qualitative).
}
\description{
\code{fat3.ad.crd} Analyses experiments in balanced
Completely Randomized Design in triple factorial
scheme with an additional treatment, considering a
fixed model.
}
\details{
The arguments sigT and mcomp will be used only
when the treatment are qualitative.
}
\note{
The \code{\link{graphics}} can be used to
construct regression plots and \code{\link{plotres}}
for residuals plots.
}
\examples{
data(ex6)
attach(ex6)
data(respAd)
fat3.ad.crd(fatorA, fatorB, fatorC, rep, resp, respAd,
quali = c(TRUE, TRUE, TRUE), mcomp = "duncan",
fac.names = c("Factor A", "Factor B", "Factor C"),
sigT = 0.05, sigF = 0.05, unfold=NULL)
}
\references{
HEALY, M. J. R. The analysis of a
factorial experiment with additional treatments.
Journal of Agricultural Science, Cambridge, v. 47,
p. 205-206. 1956.
}
\seealso{
\code{\link{fat2.crd}},
\code{\link{fat2.rbd}}, \code{\link{fat3.crd}},
\code{\link{fat3.rbd}}, \code{\link{fat2.ad.crd}},
\code{\link{fat2.ad.rbd}}, \code{\link{fat3.ad.crd}}
and \code{\link{fat3.ad.rbd}}.
}
\author{
Eric B Ferreira,
\email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
