% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fkf.R
\name{plot.fkf}
\alias{plot.fkf}
\title{Plotting fkf objects}
\usage{
\method{plot}{fkf}(
  x,
  type = c("state", "resid.qq", "qqchisq", "acf"),
  CI = 0.95,
  at.idx = 1:nrow(x$at),
  att.idx = 1:nrow(x$att),
  ...
)
}
\arguments{
\item{x}{The output of \code{\link{fkf}}.}

\item{type}{A string stating what shall be plotted (see \bold{Details}).}

\item{CI}{The confidence interval in case \code{type == "state"}. Set
\code{CI} to \code{NA} if no confidence interval shall be plotted.}

\item{at.idx}{An vector giving the indexes of the predicted state variables
which shall be plotted if \code{type == "state"}.}

\item{att.idx}{An vector giving the indexes of the filtered state variables
which shall be plotted if \code{type == "state"}.}

\item{\dots}{Arguments passed to either \code{\link{plot}},
\code{\link{qqnorm}}, \code{\link{qqplot}} or \code{\link{acf}}.}
}
\value{
Invisibly returns an list with components:
   \tabular{rl}{
  \code{distance} \tab The Mahalanobis distance of the residuals as a
  vector of length \eqn{n}. \cr
  \code{std.resid} \tab The standardized residuals as an \eqn{d \times
    n}{d * n}-matrix. It should hold that \eqn{std.resid_{ij} \; iid \sim N_d(0, I)}{std.resid[i,j] iid N_d(0,
      I)},
}
where \eqn{d} denotes the dimension of the data and \eqn{n} the number
of observations.
}
\description{
Plotting method for objects of class \code{\link{fkf}}. This function
provides tools for graphical analysis of the Kalman filter output:
Visualization of the state vector, QQ-plot of the individual
residuals, QQ-plot of the Mahalanobis distance, auto- as well as
crosscorrelation function of the residuals.
}
\details{
The argument \code{type} states what shall be plotted. \code{type}
must partially match one of the following:
\describe{
    \item{\code{state}}{The state variables are plotted. By the
      arguments \code{at.idx} and \code{att.idx}, the user can specify
      which of the predicted (\eqn{a_{t}}{at}) and filtered
      (\eqn{a_{t|t}}{att}) state variables will be drawn.}
      \item{\code{resid.qq}}{Draws a QQ-plot for each residual-series in\code{vt}.}
      \item{\code{qqchisq}}{A Chi-Squared QQ-plot will be drawn to graphically
	test for multivariate normality of the residuals based on the
	Mahalanobis distance.}
      \item{\code{acf}}{Creates a pairs plot with the autocorrelation
	function (\code{\link{acf}}) on the diagonal panels and the
	crosscorrelation function (\code{\link{ccf}}) of the residuals on the
	off-diagnoal panels.}
    }
}
\section{usage}{

\code{plot(x, type = c("state", "resid.qq", "qqchisq", "acf"),
CI = 0.95, at.idx = 1:nrow(x$at), att.idx = 1:nrow(x$att), \dots)}
}

\examples{
## <--------------------------------------------------------------------------->
## Example: Local level model for the treering data
## <--------------------------------------------------------------------------->
## Transition equation:
## alpha[t+1] = alpha[t] + eta[t], eta[t] ~ N(0, HHt)          
## Measurement equation:
## y[t] = alpha[t] + eps[t], eps[t] ~  N(0, GGt)

y <- treering
y[c(3, 10)] <- NA  # NA values can be handled

## Set constant parameters:
dt <- ct <- matrix(0)
Zt <- Tt <- array(1,c(1,1,1))
a0 <- y[1]            # Estimation of the first width
P0 <- matrix(100)     # Variance of 'a0'

## Estimate parameters:
fit.fkf <- optim(c(HHt = var(y, na.rm = TRUE) * .5,
                   GGt = var(y, na.rm = TRUE) * .5),
                 fn = function(par, ...)
                 -fkf(HHt = array(par[1],c(1,1,1)), GGt = array(par[2],c(1,1,1)), ...)$logLik,
                 yt = rbind(y), a0 = a0, P0 = P0, dt = dt, ct = ct,
                 Zt = Zt, Tt = Tt)

## Filter tree ring data with estimated parameters:
fkf.obj <- fkf(a0, P0, dt, ct, Tt, Zt, HHt = array(fit.fkf$par[1],c(1,1,1)),
               GGt = array(fit.fkf$par[2],c(1,1,1)), yt = rbind(y))

## Plot the width together with fitted local levels:
plot(y, main = "Treering data")
lines(ts(fkf.obj$att[1, ], start = start(y), frequency = frequency(y)), col = "blue")
legend("top", c("Treering data", "Local level"), col = c("black", "blue"), lty = 1)

## Check the residuals for normality:
plot(fkf.obj, type = "resid.qq")

## Test for autocorrelation:
plot(fkf.obj, type = "acf", na.action = na.pass)

}
\seealso{
\code{\link{fkf}}
}
\keyword{hplot}
