% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmo_optimal_solution.R
\name{kmo_optimal_solution}
\alias{kmo_optimal_solution}
\title{Calculates the Optimal Solution for Kayser-Meyer-Olkin (KMO) in a Dataframe}
\usage{
kmo_optimal_solution(df, squared = TRUE)
}
\arguments{
\item{df}{a dataframe with only \code{int} or \code{num} type of variables}

\item{squared}{TRUE if matrix is squared (such as adjacency matrices), FALSE otherwise}
}
\value{
A list with \enumerate{
\item \code{df} - A dataframe that has reached its optimal solution in terms of KMO values
\item \code{removed} - A list of removed variables ordened by the first to last removed during the procedure
\item \code{kmo_results} - Results of the final iteration of the \code{\link{kmo}} function
}
}
\description{
\code{kmo_optimal_solution()} call upon the \code{\link[FactorAssumptions]{kmo}} function to iterate over the variables of a dataframe.
}
\details{
If finds any individual KMO's below the optimal value of 0.5 then removes the lowest KMO value variable until no more variable has not-optimal KMO values.
}
\examples{
set.seed(123)
df <- as.data.frame(matrix(rnorm(100*10, 1, .5), ncol=10))
kmo_optimal_solution(df, squared = FALSE)

}
\seealso{
\code{\link{kmo}} for kmo computation function
}
