% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreca.R
\name{foreca}
\alias{foreca}
\alias{foreca.one_weightvector}
\alias{foreca.multiple_weightvectors}
\title{Forecastable Component Analysis}
\usage{
foreca(series, n.comp = 2, algorithm.control = list(type = "EM"), ...)

foreca.one_weightvector(
  U,
  f.U = NULL,
  spectrum.control = list(),
  entropy.control = list(),
  algorithm.control = list(),
  keep.all.optima = FALSE,
  dewhitening = NULL,
  ...
)

foreca.multiple_weightvectors(
  U,
  spectrum.control = list(),
  entropy.control = list(),
  algorithm.control = list(),
  n.comp = 2,
  plot = FALSE,
  dewhitening = NULL,
  ...
)
}
\arguments{
\item{series}{a \eqn{T \times K} array with \code{T} observations from the 
\eqn{K}-dimensional time series \eqn{\mathbf{X}_t}. Can be a \code{matrix}, \code{data.frame}, 
or a multivariate \code{ts} object.}

\item{n.comp}{positive integer; number of components to be extracted.
Default: \code{2}.}

\item{algorithm.control}{list; control settings for any \emph{iterative} ForeCA 
algorithm. See \code{\link{complete_algorithm_control}} for details.}

\item{...}{additional arguments passed to available ForeCA algorithms.}

\item{U}{a \eqn{T \times K} array with \code{T} observations from the 
\eqn{K}-dimensional \strong{whitened} (\code{\link{whiten}}) 
time series \eqn{\mathbf{U}_t}. Can be a \code{matrix}, \code{data.frame}, or a 
multivariate \code{ts} object.}

\item{f.U}{multivariate spectrum of class \code{'mvspectrum'} with 
\code{normalize = TRUE}.}

\item{spectrum.control}{list; control settings for spectrum estimation. 
See \code{\link{complete_spectrum_control}} for details.}

\item{entropy.control}{list; control settings for entropy estimation.
See \code{\link{complete_entropy_control}} for details.}

\item{keep.all.optima}{logical; if \code{TRUE}, it keeps the optimal
solutions of each random start. Default: \code{FALSE} (only returns the best solution).}

\item{dewhitening}{optional; if provided (returned by \code{\link{whiten}})
then it uses the dewhitening transformation to obtain the original
series \eqn{\mathbf{X}_t} and it uses that vector (normalized) as the initial
weightvector which corresponds to the series \eqn{\mathbf{X}_{t,i}}
with larges \code{\link{Omega}}.}

\item{plot}{logical; if \code{TRUE} a plot of the current optimal
solution \eqn{\mathbf{w}_i^*} will be shown and updated for each iteration
\eqn{i = 1, ..., } \code{n.comp} of any iterative algorithm. Default: \code{FALSE}.}
}
\value{
An object of class \code{foreca}, which is similar to the output from \code{\link[stats]{princomp}},
with the following components (amongst others):
\itemize{
\item{\code{center}:}{ sample mean \eqn{\widehat{\mu}_X} of each \code{series},}
\item{\code{whitening}:}{ whitening matrix of size \eqn{K \times K}
from \code{\link{whiten}}: \eqn{\mathbf{U}_t = (\mathbf{X}_t - \widehat{\mu}_X) \cdot whitening};
note that \eqn{\mathbf{X}_t} is centered prior to the whitening transformation,}
\item{\code{weightvectors}:}{ orthonormal matrix of size \eqn{K \times n.comp},
which converts whitened data to \code{n.comp} forecastable components (ForeCs)
\eqn{\mathbf{F}_t = \mathbf{U}_t \cdot weightvectors}, }
\item{\code{loadings}:}{ combination of whitening \eqn{\times} weightvectors to obtain the final
loadings for the original data:
\eqn{\mathbf{F}_t = (\mathbf{X}_t - \widehat{\mu}_X) \cdot whitening \cdot
weightvectors}; again, it centers \eqn{\mathbf{X}_t} first,}
\item{\code{loadings.normalized}:}{ normalized loadings (unit norm).  Note
though that if you use these normalized loadings the resulting
signals do not have variance 1 anymore.}
\item{\code{scores}:}{ \code{n.comp} forecastable components \eqn{\mathbf{F}_t}.
 They have mean 0, variance 1, and are uncorrelated.}
\item{\code{Omega}:}{ forecastability score of each ForeC of \eqn{\mathbf{F}_t}.}
}

ForeCs are ordered from most to least forecastable (according to
\code{\link{Omega}}).
}
\description{
\code{foreca} performs Forecastable Component Analysis (ForeCA) on
\eqn{\mathbf{X}_t} -- a \eqn{K}-dimensional time series with \eqn{T}
observations. Users should only call
\code{foreca}, rather than \code{foreca.one_weightvector} or
\code{foreca.multiple_weightvectors}.

\code{foreca.one_weightvector} is a wrapper around several algorithms that
solve the ForeCA optimization problem for a single weightvector \eqn{\mathbf{w}_i}
and whitened time series \eqn{\mathbf{U}_t}.

\code{foreca.multiple_weightvectors} applies \code{foreca.one_weightvector}
iteratively to \eqn{\mathbf{U}_t} in order to obtain multiple weightvectors
that yield most forecastable, uncorrelated signals.
}
\section{Warning}{


Estimating Omega directly from the ForeCs \eqn{\mathbf{F}_t} can be different
to the reported \code{$Omega} estimates from \code{foreca}.  Here is why:

In theory \eqn{f_y(\lambda)} of a linear combination
\eqn{y_t = \mathbf{X}_t \mathbf{w}} can be analytically computed from
the multivariate spectrum \eqn{f_{\mathbf{X}}(\lambda)} by the
quadratic form
\eqn{f_y(\lambda) = \mathbf{w}' f_{\mathbf{X}}(\lambda) \mathbf{w}} for all
\eqn{\lambda} (see \code{\link{spectrum_of_linear_combination}}).

In practice, however, this identity does not hold always exactly since
(often data-driven) control setting for spectrum estimation are not identical
for the high-dimensional, noisy
\eqn{\mathbf{X}_t} and the combined univariate time series \eqn{y_t}
(which is usually more smooth, less variable). Thus estimating
\eqn{\widehat{f}_y} directly  from \eqn{y_t} can give slightly different
estimates to computing it as \eqn{\mathbf{w}'\widehat{f}_{\mathbf{X}}\mathbf{w}}.  Consequently also \code{Omega} estimates
can be different.


In general, these differences are small and have no relevant implications
for estimating ForeCs.  However, in rare occasions the obtained ForeCs can have
smaller \code{Omega} than the maximum \code{Omega} across all original series.
In such a case users should not re-estimate \eqn{\Omega} from the resulting
ForeCs \eqn{\mathbf{F}_t}, but access them via \code{$Omega} provided
by \code{'foreca'} output (the univariate estimates are stored in \code{$Omega.univ}).
}

\examples{
XX <- diff(log(EuStockMarkets)) * 100
plot(ts(XX))
\dontrun{
ff <- foreca(XX[,1:4], n.comp = 4, plot = TRUE, spectrum.control=list(method="pspectrum"))
ff
summary(ff)
plot(ff)
}


\dontrun{
PW <- whiten(XX)
one.weight.em <- foreca.one_weightvector(U = PW$U,
                                        dewhitening = PW$dewhitening,
                                        algorithm.control =
                                          list(num.starts = 2,
                                               type = "EM"),
                                        spectrum.control =
                                          list(method = "mvspec"))
plot(one.weight.em)
}
\dontrun{

PW <- whiten(XX)
ff <- foreca.multiple_weightvectors(PW$U, n.comp = 2,
                                    dewhitening = PW$dewhitening)
ff
plot(ff$scores)
}
}
\references{
Goerg, G. M. (2013). \dQuote{Forecastable Component Analysis}.
Journal of Machine Learning Research (JMLR) W&CP 28 (2): 64-72, 2013.
Available at \url{http://jmlr.org/proceedings/papers/v28/goerg13.html}.
}
\keyword{iteration}
