% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ind_Evaluation_30112018.R
\name{R}
\alias{R}
\title{Calculates the indicator of information's rate of the data base}
\usage{
R(x, p_ind, b_jk, SI)
}
\arguments{
\item{x}{the data set to evaluate.}

\item{p_ind}{a vector of the relative sampling weights of the units, for which \eqn{length(p_ind) = nrow(data)}. If the weights are not relative, the following expression should be applied on the vector: \deqn{\frac{p_{ind}}{\sum_{i=1}^{n} p_{ind}}.} If no sampling weights are used, the vector of weights is reduced to a vector of values 1, i.e. \eqn{rep(1, nrow(data))}.}

\item{b_jk}{a matrix of length(b_j) rows and max(SI) columns expressing the initial weights of each sub-item of a given main-item.}

\item{SI}{an array representing the total numbers of sub-items per main-item.}
}
\value{
A numerical value giving the indicator of information's rate of the complete linguistic questionnaire. Note that the obtained value is interpreted as the more it tends to the value 1, the less the complete questionnaire contains missing values.
}
\description{
Calculates the indicator of information's rate of the data base
}
\examples{
data <- matrix(c(3,4,2,3,3,2,4,3,3,4,3,4,4,2,5,3,4,4,3,3,3,4,4,3,
3,3,4,3,3,3,3,4,4,3,5,3,4,3,3,3), ncol = 4)
data <- as.data.frame(data)
p_ind <- c(0.1,0.05,0.05,0.2,0.1,0.05,0.1,0.1,0.2,0.05)
SI1 <- 2
SI2 <- 2
SI <- c(SI1,SI2)
b_jk <- matrix(c(0.5,0.5,0.5,0.5),nrow=2) 
R(data, p_ind, b_jk, SI)
}
