% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Final_Functions.R
\name{GxEtest}
\alias{GxEtest}
\title{Joint test for genetic and gene-environment interaction effects for a single SNP}
\usage{
GxEtest(dat, snp_geno, nsim = 1e+05, K)
}
\arguments{
\item{dat}{a data frame with covariate information. Column 1 should be phenotype,
column 2 should be the environmental factor of interest, columns 3 and later should be
additional covariates}

\item{snp_geno}{a vector containing genotypic information of SNP of interest to be tested}

\item{nsim}{the number of replicates in obtaining the p-value (standard 1e5)}

\item{K}{the number of knots used to control the flexibility in modeling GxE interaction}
}
\value{
empirical p-value obtained as the proportion of T0 that are greater than
the observed test statistic T
}
\description{
Function to test for the joint genetic and gene-environment
interaction effects for a single variant using a LRT model
}
\references{
Crainiceanu, C. M., & Ruppert, D. (2004). Likelihood ratio tests in linear mixed models with one variance component.
Journal of the Royal Statistical Society Series B-Statistical Methodology, 66, 165-185. doi: 10.1111/j.1467-9868.2004.00438.x
}
