% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cond_Moments.R
\name{Cond_Moments}
\alias{Cond_Moments}
\title{Conditional statistical moments of a model output}
\usage{
Cond_Moments(parameters_set, out_set, pp_names, steps = 100)
}
\arguments{
\item{parameters_set}{matrix of dimensions n x pp, where n is the
number of runs and pp is the number of parameters.}

\item{out_set}{matrix of dimensions n x t, where n is the number of
runs and t is the number of temporary steps.}

\item{pp_names}{vector that contains the names of the parameters.}

\item{steps}{number of divisions of the parametric range.}
}
\value{
A list of arrays, each array has dimensions of steps, t, pp.
}
\description{
This function evaluates the first four statistical moments
after grouping the model output by different parametric
ranges.
}
\examples{
data("parameters_set", "out_set", "pp_names")
\donttest{
CM <- Cond_Moments(parameters_set, out_set, pp_names, steps=15)
}
}
\author{
Camila Garcia-Echeverri <cagarciae@unal.edu.co> \cr
Maria Cristina Areas-Bautista <mcarenasb@unal.edu.co> \cr

Hydrodynamics of the natural media research group - HYDS
National University of Colombia -  Bogota
}
