% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSL.R
\name{rSL}
\alias{rSL}
\title{To calculate the value of r, S and L.}
\usage{
rSL(x, pto_lat, digits = 4)
}
\arguments{
\item{x}{Selection of Ellipsoid to work between 1 = 'PSAD-56', 2 = 'SAD-69',    3 = 'WGS-84',    4 ='GRS-80 (SIRGAS)'.}

\item{pto_lat}{Point name and the latitude in radians as data.frame.}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 4}
}
\value{
data.frame with the data in the following order: "Pt", "r", "S", "L".
}
\description{
With this function it is possible to calculate the value of r, S and L.
}
\examples{
# Point name
Pto <- "St1"

# Latitude
g <- -33
m <- 38
s <- 30.123456

rad_lat <- radians(g, m, s)
print(rad_lat)

# Ellipsoidal height and Horizontal distance as data.frame
pto_lat <- data.frame(Pto, rad_lat)

# To know the ellipsoids and the order open the Ellipsoids in the package and look for it number
Ellip <- Ellipsoids
#View(Ellip)

# We choose the number 47 which is WGS84
value <- rSL(47, pto_lat, digits = 4)
print(value)
}
