% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_plotCurves.R
\name{plotCurves}
\alias{plotCurves}
\title{Generic function to plot curves}
\usage{
plotCurves(x, ...)
}
\arguments{
\item{x}{An object for which the curves are to be plotted.}

\item{...}{Additional arguments affecting the output.}
}
\value{
No value returned, plots the curves.
}
\description{
This function is a generic function to plot curves.
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- SpatialScan(method = "NPFSS", data = funi_data, sites_coord = coords, system = "WGS84",
mini = 1, maxi = nrow(coords)/2)$NPFSS

plotCurves(x = res_npfss, add_mean = TRUE, add_median = TRUE)}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_npfss <- SpatialScan(method = "NPFSS", data = funi_data[indices,], sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)$NPFSS
if(length(res_npfss$sites_clusters)>0){
plotCurves(x = res_npfss, add_mean = TRUE, add_median = TRUE)
}

}

}
\seealso{
\code{\link{plotCurves.ResScanOutputUniFunct}} and \code{\link{plotCurves.ResScanOutputMultiFunct}}
}
