% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{hrm_test_internal}
\alias{hrm_test_internal}
\title{Test for Multi-Factor High-Dimensional Repeated Measures}
\usage{
hrm_test_internal(
  formula,
  data,
  alpha = 0.05,
  subject,
  variable,
  nonparametric,
  np.correction
)
}
\arguments{
\item{formula}{A model formula object. The left hand side contains the response variable and the right hand side contains the whole- and subplot factors.}

\item{data}{Either a data.frame (one observation per row) or a list with matrices (one subject per row) for all groups containing the data}

\item{alpha}{alpha level used for calculating the critical value for the test}

\item{subject}{column name within the data frame X identifying the subjects}
}
\value{
Returns an object from class HRM containing

\item{result}{A dataframe with the results from the hypotheses tests.}

\item{formula}{The formula object which was used.}

\item{alpha}{The type-I error rate which was used.}

\item{subject}{The column name identifying the subjects.}

\item{factors}{A list containing the whole- and subplot factors.}

\item{data}{The data.frame or list containing the data.}
}
\description{
Performing main and interaction effects of up to three whole- or subplot-factors. In total, a maximum of four factors can be used. There are two different S3 methods available. The first method requires a list of matrices in the wide table format. The second methodl requres a data.frame in the long table format.
}
\keyword{internal}
