% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segsummary.R
\name{segsummary}
\alias{segsummary}
\alias{print.segsummary}
\title{Statistical summary of homogeneous segments.}
\usage{
segsummary(start = "SLK.start", end = "SLK.end", var = "deflection",
                  seg.id = "seg.id", data, by.ctg = NULL)
\method{print}{segsummary}(x, ...)
}
\arguments{
\item{start}{A character of start location name of a spatial line.}

\item{end}{A character of end location name of a spatial line.}

\item{var}{A character or a character vector of variable names,
such as a road pavement performance indicator.}

\item{seg.id}{A character of the name of new segment number.}

\item{data}{A data frame of a dataset.}

\item{by.ctg}{A character of categorical variable names.}

\item{x}{A list of segmentation result.}

\item{...}{Ignore}
}
\description{
Statistical summary of homogeneous segments.
}
\examples{
testdata <- tsdwa[1:100,]
testdata$length <- testdata$SLK.end - testdata$SLK.start
testdata <- shs(var = c("Curvature", "Deflection"), length = "length",
                testdata, range = c(0.1, 0.5))
s1 <- segsummary(start = "SLK.start", end = "SLK.end", var = c("Curvature", "Deflection"),
                 seg.id = "seg.id", testdata)
s1

}
