% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GFELEM.R
\name{GFELEM}
\alias{GFELEM}
\title{GFELEM}
\usage{
GFELEM(p, r, MF)
}
\arguments{
\item{p}{integer (a prime number)}

\item{r}{integer (a positive integer)}

\item{MF}{Integer Array containing Minimum function}
}
\value{
A vector of size p^r
}
\description{
Elements of Galois Field, GF(P^r)
}
\details{
This function returns Elements of Galois field of order p^r. To use this function, Minimum function is required.
Minimum functions are available in internal dataset. To use the Minimum function from the internal, use HadamardR:::
}
\examples{
library(HadamardR)
p<-3
r<-2
cardin=9
mf<-subset(HadamardR:::minimumfunction,HadamardR:::minimumfunction$s==cardin)
MF<-mf$coeff
GFElem<-GFELEM(p,r,MF)
GFElem
}
