% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/had_goethals_base.R
\name{had_goethals_base}
\alias{had_goethals_base}
\title{had_goethals_base}
\source{
The Base sequences were obtained from
\href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos}
}
\usage{
had_goethals_base(x)
}
\arguments{
\item{x}{integer (order of the matrix)}
}
\value{
Hadamard matrix of order x
}
\description{
had_goethals_base performs the construction of Hadamard Matrix from Goethals-Seidel method.
by using the Base sequences.
}
\details{
This function construct the Hadamard matrix of given order using base sequences.
If base sequences of length n+1,n+1,n,n are available, base sequences are converted into T-sequences of length 2n+1,2n+1,2n+1,2n+1 can be constructed.
From T-sequence of length 2n+1, Hadamard matrix of order 4(2n+1) can be constructed.
For a given order the base sequences is not available it returns NULL.

The Base sequences are stored in internal dataset. The available
Base sequences of length is 1,2,3,4,.....,35
}
\examples{
had_goethals_base(12)
#       [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8] [,9] [,10] [,11] [,12]
# [1,]    1    1    1    1    1   -1    1   -1   -1    -1     1    -1
# [2,]    1    1    1    1   -1    1   -1   -1    1     1    -1    -1
# [3,]    1    1    1   -1    1    1   -1    1   -1    -1    -1     1
# [4,]   -1   -1    1    1    1    1    1   -1   -1     1    -1     1
# [5,]   -1    1   -1    1    1    1   -1   -1    1    -1     1     1
# [6,]    1   -1   -1    1    1    1   -1    1   -1     1     1    -1
# [7,]   -1    1    1   -1    1    1    1    1    1     1     1    -1
# [8,]    1    1   -1    1    1   -1    1    1    1     1    -1     1
# [9,]    1   -1    1    1   -1    1    1    1    1    -1     1     1
#[10,]    1   -1    1   -1    1   -1   -1   -1    1     1     1     1
#[11,]   -1    1    1    1   -1   -1   -1    1   -1     1     1     1
#[12,]    1    1   -1   -1   -1    1    1   -1   -1     1     1     1
had_goethals_base(16)
#NULL
}
\references{
Goethals, J. M. and Seidel, J. J. (1967). Orthogonal matrices with zero diagnol. Canad. J. Math., 19, 259-264.
}
