% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{piecewise_xy}
\alias{piecewise_xy}
\title{Piecewise real function of two variables.}
\usage{
piecewise_xy(breaks, funs)
}
\arguments{
\item{breaks}{Numeric vector giving the breaks of functions given in \code{funs}. Must be sorted with unique values.}

\item{funs}{List of functions.}
}
\value{
Piecewise bivariate function built with the given intervals and functions.
}
\description{
Given the vectors \verb{(breaks[1],...,breaks[n])} and the list of \code{IBMPopSim} compatible
functions \verb{funs = (f[0],f[1],...,f[n])} (one value more!), \code{piecewise_xy(breaks, funs)} returns
the function
\deqn{f(x,y) = f_0(x) {1}_{y\le breaks[1]}+\sum_{k=1}^{n-1} f_k(x) {1}_{[breaks_{k}, breaks_{k+1})}(y) + f_n(x){1}_{y \ge breaks[n]}}
}
\details{
A C++ version of this function is available. See \code{vignette('IBMPopSim_cpp')} for more details.
}
\examples{
time_dep_function <- piecewise_xy(c(5),
                                  list(gompertz(0.1, 0.005), gompertz(0.08, 0.005)))
time_dep_function(0, 65)  # death intensity at time 0 and age 65.

}
