% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcm_IMT.R
\name{gpcm_IMT}
\alias{gpcm_IMT}
\title{Runs the GPCM model for use in the Information Matrix Test.}
\usage{
gpcm_IMT(data, constraint = c("gpcm", "1PL", "rasch"), IRT.param = TRUE,
  start.val = NULL, na.action = NULL, control = list())
}
\arguments{
\item{data}{A dataset with J columns and n rows.}

\item{constraint}{Constraint is either "1PL", "rasch" or "gpcm" depending on which parameter constraints should be run.}

\item{IRT.param}{logical; if TRUE then the usual IRT parametrization is used.}

\item{start.val}{If not Null, a list of starting values for the parameter estimates}

\item{na.action}{the na.action to be used on the data}

\item{control}{See gpcm function in ltm package for details.}
}
\value{
A GPCM object.
}
\description{
Runs the GPCM model for use in the Information Matrix Test.
}
\examples{
data(dataset)
model = gpcm_IMT(dataset, constraint = "rasch")
# See vignette("IMT-vignette") for more examples
}
