% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{seq_RT}
\alias{seq_RT}
\title{Function for generating sequences of runtime values}
\usage{
seq_RT(
  RT,
  from = NULL,
  to = NULL,
  by = NULL,
  length.out = NULL,
  scale = "linear"
)
}
\arguments{
\item{RT}{A list of runtime values}

\item{from}{Starting runtime value. Will be replaced by min(RT) if it is NULL or too small}

\item{to}{Stopping runtime value. Will be replaced by max(RT) if it is NULL or too large}

\item{by}{Stepsize of the sequence. Will be replaced if it is too small}

\item{length.out}{Number of values in the sequence.
'by' takes preference if both it and length.out are provided.}

\item{scale}{Scaling of the sequence. Can be either 'linear' or 'log', indicating a
linear or log-linear spacing respectively.}
}
\value{
A sequence of runtime values
}
\description{
Function for generating sequences of runtime values
}
\examples{
RTall <- get_runtimes(dsl)
seq_RT(RTall, 0, 500, length.out=10, scale='log')
}
