% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{vary_param}
\alias{vary_param}
\title{Generate copies of a \code{config} with a modified parameter}
\usage{
vary_param(
  cfg,
  param_row = NA,
  to = NA,
  from = NA,
  param_name = NA,
  host_spp = NA,
  values
)
}
\arguments{
\item{cfg}{Base \code{config} to make modified copies of}

\item{param_row}{Row number of parameter to vary, if this is specified
arguments from, to, param_name, and host_spp are unneeded}

\item{to}{The to life stage of the parameter to change.}

\item{from}{The from life stage from of the parameter to change. If this is
given, to and param_name are also needed.}

\item{param_name}{The name of the parameter to change}

\item{host_spp}{The host_spp identifying the parameter to change. Needed only
if there are multiple rows in the parameter table with the same from, to
and param_name, but different host_spp.}

\item{values}{Numeric vector of values to use for parameter}
}
\value{
A list of \code{config}s
}
\description{
Create copies of a \code{config} with a modified parameter. These new
\code{config}s can be used to see how that parameter affects the model
}
\examples{

# create new configs with different values for the parameter determining
# mortality of eggs (which is found in row 2)
cfgs <- vary_param(config_ex_1, param_row = 2, values = c(0, 0.1, 0.2))

# inspect parameter row 2 in each of the new configs to verify that we have
# the new values
lapply(cfgs, function(cfg) cfg$parameters[[2, 'param_value']])

}
