% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASS1.R
\name{PASS1}
\alias{PASS1}
\title{Modeling Judgments of Frequency with PASS 1}
\usage{
PASS1(x, y, ..., sqc, att, dec, ifc, rdm_weights = TRUE, noise = 0)
}
\arguments{
\item{x}{input handled by PASS 1. Only binary input is allowed.}

\item{y}{a second binary input handled by PASS 1. At least
two inputs are needed for the simulation.}

\item{...}{other binary inputs for modeling.}

\item{sqc}{sequence of the different objects. Each input gets
an ascending number. \code{x} gets the value \code{1},
\code{y} gets the value \code{2}, \code{...} gets the value
\code{3} and so on.
The argument \code{sqc = c(1, 2, 3, 2)} means: first
input \code{x} is processed, second input \code{y} is
processed followed by processing input number three and
fourth, th input \code{y} is used again.
So \code{sqc} contains the frequency information too.
In \code{c(1, 2, 3, 2)}, \code{x} and  the third input
are presented once. The input \code{y} is presented twice.}

\item{att}{attention is a vector with numeric values
between 0 and 1. \code{att} has the same length like
\code{sqc}, so each input processing have its own value
and PASS 1 can modulate attention by time or input.
If  \code{att} is exact one numeric value
(e.g. \code{ att = .1}), all inputs get the
same parameter of attention.}

\item{dec}{decay is a vector with numeric values between
-1 and 0. \code{dec} has the same length as \code{sqc}, so each
input processing have its own value and PASS 1 can modulate
decay by time. If \code{dec} is exact
one numeric value (e.g. \code{dec = -.1}), all inputs get the
same parameter of decay.}

\item{ifc}{interference is a vector with numeric values
between -1 and 0. \code{ifc} must have the same length as
\code{sqc}. So each inputprocessing have its own value and
PASS 1 can modulate inference by time. If \code{ifc} is exact
one numeric value (e.g. \code{ ifc = -.1}), all inputs get the
same parameter of inference.}

\item{rdm_weights}{a logical value indicating whether random
weights in the neural network are used or not. If
\code{rdm_weights = FALSE} all network connections are zero
at the beginning.}

\item{noise}{a proportion between 0 and 1 which determine
the number of randome activiated inputunits (hihger numbers
indicate higher noise).}
}
\value{
\code{PASS1} returns the relative judgment of frequency
for each input.
}
\description{
Modeling Judgments of Frequency with PASS 1
}
\details{
PASS 1 is a simple neural pattern associator learning
by delta rule.

Learning:
\deqn{if U_{i} and U_{j} are activated, then
\Delta w_{ij} = \Theta_{1} ( 1 - w_{ij})}{if Ui and Uj are
activated, then \Delta wij = \Theta1 * ( 1 - wij)}
Interference:
\deqn{if either U_{i} or U_{j} is activated, then
\Delta w_{ij} = \Theta_{2} * w_{ij}}{if either Ui or Uj is
activated, then \Delta wij = \Theta2 * wij}
Decay:
\deqn{if neither U_{i} nor U_{j} is activated, then
\Delta w_{ij} = \Theta_{3} * w_{ij}}{if neither Ui nor Uj is
activated, then \Delta wij = \Theta3 * wij}
}
\examples{
o1 <- c(1, 0, 0, 0)
o2 <- c(0, 1, 0, 0)
o3 <- c(0, 0, 1, 0)
o4 <- c(0, 0, 0, 1)
PASS1(o1, o2, o3, o4,
      sqc = rep(1:4, 4:1), att = .1, dec = -.05,
      ifc = -.025, rdm_weights = FALSE, noise = 0)
}
\references{
Sedlmeier, P. (2002). Associative learning and
frequency judgements: The PASS model. In P. Sedlmeier,
T. Betsch (Eds.), \emph{Etc.: Frequency processing and cognition}
(pp. 137-152). New York: Oxford University Press.
}
