% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confintKspm.R
\name{confint.kspm}
\alias{confint.kspm}
\title{Confidence interavls for linear part of model parameters}
\usage{
\method{confint}{kspm}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{parm}{a vector of names specifying which parameters are to be given confidence intervals. If missing, all parameters are considered.}

\item{level}{the confidence level required. By default 0.95.}

\item{...}{additional optional argument (currently unused).}
}
\value{
A matrix with column giving lower and upper confidence limits for each parameter. These are labelled as \eqn{\frac{1-level}{2}}{(1-level) / 2} and \eqn{1 - \frac{1-level}{2}}{1-(1-level)/2} in percentage.
}
\description{
Computes confidence intervals for one or more parameters in the linear part of a fitted model of class "kspm".
}
\details{
For objects of class "kspm", the confidence interval is based on student distribution and effective degree of freedom of the model.
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0))
confint(fit)

}
\seealso{
\link{kspm} for fitting model, \link{summary.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
