% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koboconnect.R
\name{kobo_export_create}
\alias{kobo_export_create}
\title{Create an export}
\usage{
kobo_export_create(
  url = "kobo.humanitarianresponse.info",
  uname = "",
  pwd = "",
  assetid = "",
  type = "csv",
  all = "false",
  lang = "_default",
  hierarchy = "false",
  include_grp = "true",
  grp_sep = "/"
)
}
\arguments{
\item{url}{The `[url]` of kobotoolbox Default is "kobo.humanitarianresponse.info".}

\item{uname}{is username of your kobotoolbox account}

\item{pwd}{is the password of the account}

\item{assetid}{is the id of the asset for which the export is to be created}

\item{type}{is the type of export to be created. For e.g. 'xls' or 'csv'.}

\item{all}{takes logical value in string format. "true" indicates the field from all versions of the asset to be used. Defaults to "false".}

\item{lang}{takes the language. For e.g. "English (en)".}

\item{hierarchy}{takes logical value in string format. "true" indicates hierarchy will be used in all labels. Default value is "false".}

\item{include_grp}{defines whether or not to include groups. Default value is "true".}

\item{grp_sep}{is the group separator. Default value is "/".}
}
\value{
The function returns the token associated with your id and password in the given url.
}
\description{
`kobo_export_create` is a wrapper for kobotoolbox API `https://[url]/exports/..`
}
\details{
The function creates an export of survey data. If successful, returns the URL of the data that can be directly downloaded/read/imported in R.
}
