% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{create_model}
\alias{create_model}
\title{Pre-defined Neural Network for Longitudinal Data}
\usage{
create_model(
  rnn_inputs,
  recurrent_droppout,
  inputs,
  layer_dropout,
  n_nodes_hidden_layers,
  loss_function,
  opt,
  metric
)
}
\arguments{
\item{rnn_inputs}{The number of inputs (integers) per each LSTM (vector of length 10).}

\item{recurrent_droppout}{The dropout to be applied in the LSTMs (between 0 and 1).}

\item{inputs}{The number of inputs (integer) to be concatenated with the output of the LSTMs.}

\item{layer_dropout}{The dropout to be applied between the hidden layers (between 0 and 1).}

\item{n_nodes_hidden_layers}{The number of nodes in the hidden layers (2 in total).}

\item{loss_function}{The loss function to be used.}

\item{opt}{The optimizer to be used.}

\item{metric}{The metric to be used.}
}
\value{
The model object built in Keras.
}
\description{
Create the Neural Network model (Keras).
}
\examples{
inp = c(20,24,24,24,16,16,16,16,16,15)
rec_drop = rep(0.1,10)
l_drop = c(0.1,0.1)
\dontrun{
create_model(inp,rec_drop,232,c(0.1,0.1),l_drop,'mean_squared_error','adam','mean_absolute_error')
}
# The functions require to have python installed
# As well as tensorflow, keras and reticulate package.
}
