% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDpair.R
\name{LDpair}
\alias{LDpair}
\title{Investigates potentially correlated alleles for a
pair of variants.}
\usage{
LDpair(var1, var2, pop = "CEU", token = NULL, output = "table", file = FALSE)
}
\arguments{
\item{var1}{the first RS number or genomic coordinate (e.g. "chr7:24966446")}

\item{var2}{the second RS number or genomic coordinate (e.g. "ch7:24966446")}

\item{pop}{a 1000 Genomes Project population(s), (e.g. YRI or CEU), multiple allowed, default = "CEU"}

\item{token}{LDlink provided user token, default = NULL, register for token at  \url{https://ldlink.nci.nih.gov/?tab=apiaccess}}

\item{output}{two output options available, "text", which displays a two-by-two matrix displaying haplotype counts and allele frequencies along with other statistics, or "table", which displays the same data in rows and columns, default = "table"}

\item{file}{Optional character string naming a path and file for saving results.  If file = FALSE, no file will be generated, default = FALSE.}
}
\value{
text or data frame, depending on the output option
}
\description{
Investigates potentially correlated alleles for a
pair of variants.
}
\examples{
\dontrun{LDpair(var1 = "rs3", var2 = "rs4", pop = "YRI", token = Sys.getenv("LDLINK_TOKEN"))}
\dontrun{LDpair("rs3", "rs4", "YRI", token = Sys.getenv("LDLINK_TOKEN"), "text")}

}
