% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_sam_lspace.R
\name{com_sam_lspace}
\alias{com_sam_lspace}
\title{Comparing sample L-moment ratios with L-spaces of various distributions on the L-moments ratio diagram}
\usage{
com_sam_lspace(sample, type = "m", Dist = "BrIII", color = "red", shape = 8)
}
\arguments{
\item{sample}{for a single site, sample is a vector of observations, e.x. FLOW_AMAX. For multiple sites, sample is a dataframe consisting of multiple columns where each column has the data observed at one site; this dataframe should have column names as station names, e.x. FLOW_AMAX_MULT.}

\item{type}{the type of the sample. It can be "s" for single site, the default, or "m" for multiple sites.}

\item{Dist}{select the distribution to plot its L-space in the background. This can be "BrIII" for Burr Typr-III distribution, "BrXII" for Burr Typr-XII distribution, or "GG" for Generalized Gamma distribution. The default Dist is "BrIII".}

\item{color}{color of the L-point/s, default is "red".}

\item{shape}{shape of the L-point/s, default is 8.}
}
\value{
ggplot plot comparing sample/s L-point/s with L-space of a distribution on the L-moment ratio diagram
}
\description{
Comparing sample L-moment ratios with L-spaces of various distributions on the L-moments ratio diagram
}
\examples{

com_plot_BrIII <- com_sam_lspace(LMoFit::FLOW_AMAX, type = "s", Dist = "BrIII")
com_plot_BrXII <- com_sam_lspace(LMoFit::FLOW_AMAX, type = "s", Dist = "BrXII")
com_plot_GG <- com_sam_lspace(LMoFit::FLOW_AMAX, type = "s", Dist = "GG")
com_plot_BrIII <- com_sam_lspace(LMoFit::FLOW_AMAX_MULT, type = "m", Dist = "BrIII")
com_plot_BrXII <- com_sam_lspace(LMoFit::FLOW_AMAX_MULT, type = "m", Dist = "BrXII")
com_plot_GG <- com_sam_lspace(LMoFit::FLOW_AMAX_MULT, type = "m", Dist = "GG")

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
