% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_samlmom_lspace.R
\name{con_samlmom_lspace}
\alias{con_samlmom_lspace}
\title{Condition of sample lpoints, as inside/outside of specific L-spaces on the L-moments ratio diagram, using sample lmoments.}
\usage{
con_samlmom_lspace(samplelmom, Dist = "BrIII")
}
\arguments{
\item{samplelmom}{L-moments as c(l1, l2, l3, l4, t2, t3, t4). Use get_sample_lmom() to obtain these lmoments.}

\item{Dist}{select the distribution to plot its L-space in the background. This can be "BrIII" for Burr Typr-III distribution, "BrXII" for Burr Typr-XII distribution, or "GG" for Generalized Gamma distribution. The default Dist is "BrIII". The default is set to BrIII.}
}
\value{
The condition of the L-points in regards to the selected L-space as inside or outside.
}
\description{
Condition of sample lpoints, as inside/outside of specific L-spaces on the L-moments ratio diagram, using sample lmoments.
}
\examples{

sample <- LMoFit::FLOW_AMAX
samplelmom <- get_sample_lmom(x = sample)
con_samlmom_lspace(samplelmom, Dist = "BrIII")
con_samlmom_lspace(samplelmom, Dist = "BrXII")
con_samlmom_lspace(samplelmom, Dist = "GG")

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
