% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarylswpbasis.R
\name{summary.LSWPbasis}
\alias{summary.LSWPbasis}
\title{Summary method for Objects of Class LSWPbasis}
\usage{
\method{summary}{LSWPbasis}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"LSWPbasis"}, typically (but not exclusively) returned by the function \code{LSWPbasis}.}

\item{...}{not currently used.}
}
\value{
Print an object of class \code{LSWPbasis} with LSWP basis notation.
}
\description{
\code{summary.LSWPbasis} returns a table containing the wavelet packet basis and its wavelet packet bases index notation.
}
\details{
This function is used to print a wavelet packet basis with the wavelet packet basis index notation \code{p = 1,2,...,|b|},
where |b| is the number of packets in a wavelet packet basis as defined in Cardinali and Nason (2017). The doublets \code{"j_p, i_p"} refer,
to the scale and packet index within each scale, respectively.
}
\examples{

wpb <- LSWPbasis(x = sp500, wavelet = 'la8', lev.max = 4, smooth = TRUE, spa = 0.35)
summary(wpb)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{LSWPbasis}}, \code{\link{best.basis}}
}
\author{
Alessandro Cardinali
}
