% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_layer_output.R
\name{extract_layer_output}
\alias{extract_layer_output}
\title{Extracts values from layer data and organizes layer-wise variables in columns}
\usage{
extract_layer_output(dat, layers = NULL, value_vars = NULL, sep = "")
}
\arguments{
\item{dat}{Data.frame with layer data organized in rows and identified by a
layer number column \code{nl}.}

\item{layers}{Integer vector addressing the layer numbers (nl) to be
extracted from dat. If not supplied, values from all layers will be
returned.}

\item{value_vars}{Character vector containing names of value-variables to be
extracted from dat. If not supplied, \code{value_vars} will be guessed.}

\item{sep}{Separation character for constructig names from variable name and
layer index.}
}
\value{
A data.table with the layers' values of the variables organized in
  columns (wide format) with the names being made up of the variable name and
  layer number.
}
\description{
Convenience function to reorganize soil layer data such as BELO and SWAT to
the wide format, by casting variables with the layer number, using
data.table's \code{dcast}-function.
}
\examples{
# create a data.frame with monthly values
# identifiers: layer number, yr and mo
df <- expand.grid(nl = 1:5,
                  yr = 2002:2003,
                  mo = 1:12)
df
#add a value variable
df$var <- runif(nrow(df), -1,0)

extract_layer_output(df)

# add more variables
df$var1 <- runif(nrow(df), 1,2)
df$var2 <- runif(nrow(df), 2,3)

# extract specific layers
extract_layer_output(df,layers = 2:4, sep = "_")

#extract specific variables
extract_layer_output(df, layers = 2:4, value_vars = c("var1", "var2"), sep = "_")
}
