% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntersectLineCircle.R
\name{IntersectLineCircle}
\alias{IntersectLineCircle}
\title{Finds the intersection between a line and a circumference}
\usage{
IntersectLineCircle(Line, C, r)
}
\arguments{
\item{Line}{Line object previously created with \code{CreateLinePoints} or \code{CreateLineAngle}}

\item{C}{Vector containing the xy-coordinates of the center of the circumference}

\item{r}{Radius for the circumference}
}
\value{
Returns a vector containing the xy-coordinates of the intersection points. In case of no intersection, the function tells the user
}
\description{
\code{IntersectLineCircle} finds the intesection between a line and a circumference
}
\examples{
P1 <- c(0,0)
P2 <- c(1,1)
Line <- CreateLinePoints(P1, P2)
C <- c(0,0)
r <- 2
intersection <- IntersectLineCircle(Line, C, r)
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
Draw(Line, "black")
Draw(CreateArcAngles(C, r, 0, 360), "black")
Draw(intersection[1,], "red")
Draw(intersection[2,], "red")
}
