% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_train}
\alias{opf_train}
\title{Executes the training phase of the OPF classifier}
\usage{
opf_train(dataSet, precomputedDistance = NA)
}
\arguments{
\item{dataSet}{The training object produced by the opf_split (subGraph object)}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns a list which contains the classifier object and the classification list object
}
\description{
Executes the training phase of the OPF classifier
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.5,0,0.5,0)
T <- X$training
T2 <- X$testing
Y <- opf_train(T)
class <- opf_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
