% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearDetect-package.R
\name{var.second.step.search}
\alias{var.second.step.search}
\title{Exhaustive search step}
\usage{
var.second.step.search(
  data_y,
  q,
  max.iteration = max.iteration,
  tol = tol,
  cp.first,
  beta.est,
  blocks
)
}
\arguments{
\item{data_y}{input data matrix, with each column representing the time series component}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{cp.first}{the selected break points after the first step}

\item{beta.est}{the estimated parameters by block fused lasso}

\item{blocks}{the blocks}
}
\value{
A list object, which contains the followings
\describe{
  \item{cp.final}{a set of selected break point after the exhaustive search step}
  \item{phi.hat.list}{the estimated coefficient matrix for each segmentation}
}
}
\description{
Perform the exhaustive search to "thin out" redundant break points.
}
