% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDLS.R
\name{cross.Peri}
\alias{cross.Peri}
\title{Cross periodogram of vector valued time series X and Y}
\usage{
cross.Peri(X, Y)
}
\arguments{
\item{X}{data matrix.}

\item{Y}{data matrix.}
}
\description{
Calculates the cross periodogram of the vector valued time series X and Y.
}
\examples{
T<-500
d<-c(0.4, 0.2, 0.3)
data<-FI.sim(T, q=3, rho=0, d=d)
X<-data[,1:2]
Y<-data[,3]
cper<-cross.Peri(X, Y)
pmax<-max(Re(cper),Im(cper))
pmin<-min(Re(cper),Im(cper))
plot(Re(cper[1,,]), type="h", ylim=c(pmin,pmax))
lines(Im(cper[1,,]), col=2)
plot(Re(cper[2,,]), type="h", ylim=c(pmin,pmax))
lines(Im(cper[2,,]), col=2)
}
