% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.fullProcess}
\alias{plot.fullProcess}
\title{Plot the path obtained from \code{\link{fullProcess}} function}
\usage{
\method{plot}{fullProcess}(
  x,
  log.lambda = FALSE,
  lambda.lines = FALSE,
  lambda.opt = c("min", "max", "both"),
  ...
)
}
\arguments{
\item{x}{\code{\link{fullProcess}} object}

\item{log.lambda}{If TRUE, use log(lambda) instead of lambda in abscissa}

\item{lambda.lines}{If TRUE, add vertical lines at lambda values}

\item{lambda.opt}{If there is several optimal lambdas, which one to print "min", "max" or "both"}

\item{...}{Other parameters for plot function}
}
\description{
Plot the path obtained from \code{\link{fullProcess}} function
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- fullProcess(X, y)
# Plot the solution path
plot(res)
}
\seealso{
\link{fullProcess}
}
