% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{randomizeInitState}
\alias{randomizeInitState}
\title{Transformation of vector with initial states I for various observations. Data preparation stage for simulation.}
\usage{
randomizeInitState(StatPr, X, p = 1)
}
\arguments{
\item{StatPr}{Vector (m x 1), m - number of states, m = 2,3,.. .The vector with stationary probabilities, user-defined vector.}

\item{X}{Matrix (n x k), n - number of observations, k - number of columns (k - 1 - number of regressors).
The matrix is needed to get the number of observations.}

\item{p}{Scalar (from 1 to +inf), random number for simulation. The default value is 1.}
}
\value{
Vector with new initial states, according to stationary distribution of the states for the random environment.
}
\description{
Additional function to be used for simulation purposes (academical or research).
Transforming of vector with initial states I for various observations with respect to stationary distribution of the states for the random environment.
}
\details{
The initial states (m - number of states, m = 2,3,...) for various observations are independent and are chosen with respect to stationary distribution of the states for the random environment.
The vector with stationary probabilities is user-defined vector.
}
\examples{
Xtest <- cbind(rep_len(1,10),c(2,5,7,3,1,1,2,2,3,6), c(5,9,1,2,3,2,3,5,2,2))
StatPr <- matrix (c(0.364,0.242,0.394), nrow = 3, ncol = 1)
randomizeInitState(StatPr,Xtest,1)
}
